/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.sharing;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.sharing.Messages;
import com.aptana.git.ui.internal.sharing.SharingWizard;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

class ExistingOrNewPage
extends WizardPage {
    private final SharingWizard myWizard;
    private Button button;
    private Tree tree;
    private Text repositoryToCreate;
    private IPath minumumPath;

    ExistingOrNewPage(SharingWizard w) {
        super(ExistingOrNewPage.class.getName());
        this.setTitle(Messages.ExistingOrNewPage_Title);
        this.setDescription(Messages.ExistingOrNewPage_Description);
        this.myWizard = w;
    }

    public void createControl(Composite parent) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(3, false));
        g.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tree = new Tree((Composite)g, 2050);
        this.tree.setHeaderVisible(true);
        this.tree.setLayout((Layout)new GridLayout());
        this.tree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).create());
        TreeColumn c1 = new TreeColumn(this.tree, 0);
        c1.setText(Messages.ExistingOrNewPage_ProjectColumn_Label);
        c1.setWidth(100);
        TreeColumn c2 = new TreeColumn(this.tree, 0);
        c2.setText(Messages.ExistingOrNewPage_PathColumn_Label);
        c2.setWidth(400);
        TreeColumn c3 = new TreeColumn(this.tree, 0);
        c3.setText(Messages.ExistingOrNewPage_RepositoryColumn_Label);
        c3.setWidth(200);
        IProject[] iProjectArray = this.myWizard.projects;
        int n = this.myWizard.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setData((Object)project);
            treeItem.setText(0, project.getName());
            treeItem.setText(1, project.getLocation().toOSString());
            URI gitDir = this.getGitRepositoryManager().gitDirForURL(project.getLocationURI());
            if (gitDir == null) {
                treeItem.setText(2, "");
            } else {
                treeItem.setText(2, gitDir.getPath());
            }
            ++n2;
        }
        this.button = new Button((Composite)g, 8);
        this.button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.button.setText(Messages.ExistingOrNewPage_CreateButton_Label);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int n;
                int n2;
                IProject[] iProjectArray;
                IPath gitDir = Path.fromOSString((String)ExistingOrNewPage.this.repositoryToCreate.getText()).append(".git");
                try {
                    if (GitExecutable.instance() == null) {
                        throw new CoreException((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.ExistingOrNewPage_UnabletoFindGitExecutableError));
                    }
                    ExistingOrNewPage.this.getGitRepositoryManager().create(gitDir.removeLastSegments(1));
                    iProjectArray = ExistingOrNewPage.this.getProjects();
                    n2 = iProjectArray.length;
                    n = 0;
                    while (n < n2) {
                        IProject project = iProjectArray[n];
                        if (!gitDir.toString().contains("..")) {
                            project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        ++n;
                    }
                }
                catch (CoreException e2) {
                    IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (String)NLS.bind((String)Messages.ExistingOrNewPage_ErrorFailedToRefreshRepository, (Object)gitDir), (Throwable)e2, (String)"com.aptana.git.core/debug");
                }
                iProjectArray = ExistingOrNewPage.this.tree.getSelection();
                n2 = iProjectArray.length;
                n = 0;
                while (n < n2) {
                    IProject ti = iProjectArray[n];
                    ti.setText(2, gitDir.toString());
                    ++n;
                }
                ExistingOrNewPage.this.updateCreateOptions();
                ExistingOrNewPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.repositoryToCreate = new Text((Composite)g, 2052);
        this.repositoryToCreate.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(1, 1).create());
        this.repositoryToCreate.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (e.text == null) {
                    return;
                }
                IPath fromOSString = Path.fromOSString((String)e.text);
                ExistingOrNewPage.this.button.setEnabled(ExistingOrNewPage.this.minumumPath.matchingFirstSegments(fromOSString) == fromOSString.segmentCount());
            }
        });
        Text l = new Text((Composite)g, 0);
        l.setEnabled(false);
        l.setEditable(false);
        l.setText(String.valueOf(File.separatorChar) + ".git");
        l.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExistingOrNewPage.this.updateCreateOptions();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateCreateOptions();
        this.setControl((Control)g);
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    private void updateCreateOptions() {
        this.minumumPath = null;
        IPath p = null;
        TreeItem[] treeItemArray = this.tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            String path = ti.getText(2);
            if (path.length() != 0) {
                p = null;
                break;
            }
            String gitDirParentCandidate = ti.getText(1);
            IPath thisPath = Path.fromOSString((String)gitDirParentCandidate);
            if (p == null) {
                p = thisPath;
            } else {
                int n3 = p.matchingFirstSegments(thisPath);
                p = p.removeLastSegments(p.segmentCount() - n3);
            }
            ++n2;
        }
        this.minumumPath = p;
        if (p != null) {
            this.repositoryToCreate.setText(p.toOSString());
        } else {
            this.repositoryToCreate.setText("");
        }
        this.button.setEnabled(p != null);
        this.repositoryToCreate.setEnabled(p != null);
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        if (this.tree.getItemCount() == 1) {
            TreeItem ti = this.tree.getItem(0);
            String path = ti.getText(2);
            if (path.length() == 0) {
                return false;
            }
        } else {
            if (this.tree.getSelectionCount() == 0) {
                return false;
            }
            TreeItem[] treeItemArray = this.tree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem ti = treeItemArray[n2];
                String path = ti.getText(2);
                if (path.length() == 0) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public IProject[] getProjects() {
        if (this.tree.getItemCount() == 1) {
            TreeItem ti = this.tree.getItem(0);
            return new IProject[]{(IProject)ti.getData()};
        }
        IProject[] ret = new IProject[this.tree.getSelection().length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (IProject)this.tree.getSelection()[i].getData();
            ++i;
        }
        return ret;
    }
}

